/* - MotorControl full -
 * This example demonstrates the basic usage of a Phidget MotorControl.  It 
 * demonstrates the manipulation of the velocity and acceleration of the motor, 
 * as well as displays the data from generated events.
 *
 * Please note that this example was designed to work with only one Phidget 
 * MotorControl connected.
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package MotorControl;

import com.phidgets.MotorControlPhidget;
import com.phidgets.PhidgetException;

import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

import listeners.*;

public class MotorControl extends javax.swing.JFrame {
    
    private static String runArgs[];
    private MotorControlPhidget mc;
    private MCAttachListener attach_listener;
    private MCDetachListener detach_listener;
    private MCErrorListener error_listener;
    private MCCurrentChangeListener current_listener;
    private MCInputChangeListener input_listener;
    private MCVelocityChangeListener velocity_listener;
    private JCheckBox inputArray[];
    
    /** Creates new form MotorControl */
    public MotorControl() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        numMotorsTxt = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        numInTxt = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        motorCmb = new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        currVelTxt = new javax.swing.JTextField();
        maxVelTxt = new javax.swing.JTextField();
        accelTxt = new javax.swing.JTextField();
        currentTxt = new javax.swing.JTextField();
        maxVelScrl = new javax.swing.JSlider();
        accelScrl = new javax.swing.JSlider();
        jPanel3 = new javax.swing.JPanel();
        in0Chk = new javax.swing.JCheckBox();
        in1Chk = new javax.swing.JCheckBox();
        in2Chk = new javax.swing.JCheckBox();
        in3Chk = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("MotorControl - full");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("MotorControl Info"));
        attachedTxt.setEditable(false);

        jLabel1.setText("Attached:");

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setFont(new java.awt.Font("Tahoma", 0, 11));
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        jScrollPane1.setViewportView(nameTxt);

        jLabel2.setText("Name:");

        serialTxt.setEditable(false);

        jLabel3.setText("Serial No.:");

        versionTxt.setEditable(false);

        jLabel4.setText("Version:");

        numMotorsTxt.setEditable(false);

        jLabel5.setText("Motors:");

        numInTxt.setEditable(false);

        jLabel13.setText("Inputs:");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(35, 35, 35)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jLabel1)
                    .add(jLabel2)
                    .add(jLabel4)
                    .add(jLabel3)
                    .add(jLabel5)
                    .add(jLabel13))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, numInTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, numMotorsTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, versionTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, serialTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, attachedTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1))
                .addContainerGap(54, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(attachedTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel1))
                .add(15, 15, 15)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel2))
                .add(16, 16, 16)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(serialTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel3))
                .add(16, 16, 16)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(versionTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel4))
                .add(15, 15, 15)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(numMotorsTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel5))
                .add(19, 19, 19)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(numInTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel13))
                .addContainerGap(24, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Motor Data"));
        motorCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                motorCmbActionPerformed(evt);
            }
        });

        jLabel6.setText("Choose Motor:");

        jLabel7.setText("Current Velocity:");

        jLabel8.setText("Maximum Velocity:");

        jLabel9.setText("Acceleration:");

        jLabel10.setText("Current:");

        jLabel11.setText("Set Maximum Velocity:");

        jLabel12.setText("Set Acceleration:");

        currVelTxt.setEditable(false);

        maxVelTxt.setEditable(false);

        accelTxt.setEditable(false);

        currentTxt.setEditable(false);

        maxVelScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                maxVelScrlStateChanged(evt);
            }
        });

        accelScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                accelScrlStateChanged(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(jLabel11)
                        .add(47, 47, 47)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(accelScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 134, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel12)))
                    .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2Layout.createSequentialGroup()
                            .add(7, 7, 7)
                            .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                .add(jLabel6)
                                .add(jLabel7))
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(motorCmb, 0, 165, Short.MAX_VALUE)
                                .add(currVelTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 165, Short.MAX_VALUE)))
                        .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2Layout.createSequentialGroup()
                            .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                .add(jLabel9)
                                .add(jLabel8)
                                .add(jLabel10))
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(currentTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 165, Short.MAX_VALUE)
                                .add(maxVelTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 163, Short.MAX_VALUE)
                                .add(accelTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 165, Short.MAX_VALUE)))))
                .add(95, 95, 95))
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(maxVelScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 134, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(249, Short.MAX_VALUE))
        );

        jPanel2Layout.linkSize(new java.awt.Component[] {accelTxt, currVelTxt, currentTxt, maxVelTxt, motorCmb}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel6)
                    .add(motorCmb, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(15, 15, 15)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel7)
                    .add(currVelTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(14, 14, 14)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel8)
                    .add(maxVelTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(14, 14, 14)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel9)
                    .add(accelTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(15, 15, 15)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel10)
                    .add(currentTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(22, 22, 22)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel11)
                    .add(jLabel12))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(maxVelScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(accelScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(21, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Input Data"));
        in0Chk.setText("Input 0");
        in0Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in0Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in1Chk.setText("Input 1");
        in1Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in1Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in2Chk.setText("Input 2");
        in2Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in2Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in3Chk.setText("Input 3");
        in3Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in3Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(40, 40, 40)
                .add(in0Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in1Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in2Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in3Chk)
                .addContainerGap(39, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(in0Chk)
                    .add(in1Chk)
                    .add(in2Chk)
                    .add(in3Chk))
                .addContainerGap(23, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 321, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {jPanel1, jPanel2, jPanel3}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Initialize the MotorConrol object and hook the event listeners
     **/
    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        inputArray = new JCheckBox[4];
        
        inputArray[0] = in0Chk;
        inputArray[1] = in1Chk;
        inputArray[2] = in2Chk;
        inputArray[3] = in3Chk;
        
        for(int i = 0; i < 4; i++)
        {
            inputArray[i].setVisible(false);
            inputArray[i].setEnabled(false);
        }
        
        motorCmb.setEnabled(false);
        maxVelScrl.setEnabled(false);
        accelScrl.setEnabled(false);
        
        //The minimum velocity for a motor is -100, the maximum is 100
        maxVelScrl.setMaximum(100);
        maxVelScrl.setMinimum(-100);
        
        jLabel10.setVisible(false);
        currentTxt.setVisible(false);
        
        try
        {
            mc = new MotorControlPhidget();
            
            attach_listener = new MCAttachListener(this, this.attachedTxt, this.nameTxt, 
            this.serialTxt, this.versionTxt, this.numMotorsTxt, this.numInTxt,
            this.currVelTxt, this.maxVelTxt, this.accelTxt, 
            this.jLabel10, this.currentTxt, this.motorCmb, this.maxVelScrl, 
            this.accelScrl, this.inputArray);
            
            detach_listener = new MCDetachListener(this, this.attachedTxt, this.nameTxt, 
            this.serialTxt, this.versionTxt, this.numMotorsTxt, this.numInTxt,
            this.currVelTxt, this.maxVelTxt, this.accelTxt, 
            this.jLabel10, this.currentTxt, this.motorCmb, this.maxVelScrl, 
            this.accelScrl, this.inputArray);
            
            error_listener = new MCErrorListener(this);
            
            current_listener = new MCCurrentChangeListener(this.currentTxt, this.motorCmb);
            
            input_listener = new MCInputChangeListener(this.inputArray);
            
            velocity_listener = new MCVelocityChangeListener(this.mc, this, this.currVelTxt, this.motorCmb);
            
            mc.addAttachListener(attach_listener);
            mc.addDetachListener(detach_listener);
            mc.addErrorListener(error_listener);
            mc.addCurrentChangeListener(current_listener);
            mc.addInputChangeListener(input_listener);
            mc.addMotorVelocityChangeListener(velocity_listener);
            
            //This assumes that if there is a command line argument, it is a serial number
            //and we try to open that specific device. Otherwise, open any device.
            if((runArgs.length > 1) && (runArgs[1].equals("remote")))
            {
                mc.open(Integer.parseInt(runArgs[0]), null);
            }
            if(runArgs.length > 0)
            {
                mc.open(Integer.parseInt(runArgs[0]));
            }
            else
            {
                mc.openAny();
            }
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    /**
     * When a motor is selected, display its current velocity and acceleration data as well as the trakbar controls
     **/
    private void motorCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_motorCmbActionPerformed
        if(motorCmb.isEnabled())
        {
            try
            {
                maxVelScrl.setValue((int)mc.getVelocity(((Integer)motorCmb.getSelectedItem()).intValue()));
                maxVelTxt.setText(Integer.toString(maxVelScrl.getValue())); 
            }
            catch (PhidgetException ex)
            {
                maxVelScrl.setValue(0);
                maxVelTxt.setText(Integer.toString(maxVelScrl.getValue()));
            }
            
            try
            {
                accelScrl.setValue((int)mc.getAcceleration(((Integer)motorCmb.getSelectedItem()).intValue())); 
                accelTxt.setText(Double.toString(mc.getAcceleration(((Integer)motorCmb.getSelectedItem()).intValue())));
            }
            catch(PhidgetException e)
            {
                accelScrl.setValue(accelScrl.getMinimum()); 
                accelTxt.setText(Integer.toString(accelScrl.getValue()));
            }
        }
    }//GEN-LAST:event_motorCmbActionPerformed

    /**
     * When the velocity trakbar is changed send this data tothe motor control to affect the motor
     * If no motor control is attached, a PhidgetException will be thrown, so we 
     * will catch it and deal with it accordingly
     **/
    private void maxVelScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_maxVelScrlStateChanged
        if(maxVelScrl.isEnabled())
        {
            try
            {
                mc.setVelocity(((Integer)motorCmb.getSelectedItem()).intValue(), maxVelScrl.getValue());
                maxVelTxt.setText(Integer.toString(maxVelScrl.getValue()));
            }
            catch (PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
                attachedTxt.setText("false");
                nameTxt.setText("");
                serialTxt.setText("");
                versionTxt.setText("");
                numMotorsTxt.setText("");
                numInTxt.setText("");
                currVelTxt.setText("");
                maxVelTxt.setText("");
                accelTxt.setText("");

                jLabel10.setVisible(false);
                currentTxt.setText("");
                currentTxt.setVisible(false);

                motorCmb.setSelectedIndex(0);
                motorCmb.removeAllItems();
                motorCmb.setEnabled(false);

                int i;
                for(i = 0; i < 4; i++)
                {
                    inputArray[i].setVisible(false);
                }
                
                maxVelScrl.setEnabled(false);
                accelScrl.setEnabled(false);
            }
            
        }
    }//GEN-LAST:event_maxVelScrlStateChanged

    /**
     * When the acceleration trakbar is changed send this data to the motor 
     * control to affect the motor
     * If no motor control is attached, a PhidgetException will be thrown, so 
     * we will catch it and deal with it accordingly
     **/
    private void accelScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_accelScrlStateChanged
        if(accelScrl.isEnabled())
        {
            try {
                mc.setAcceleration(((Integer)motorCmb.getSelectedItem()).intValue(), accelScrl.getValue());
                accelTxt.setText(Integer.toString(accelScrl.getValue()));
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
                attachedTxt.setText("false");
                nameTxt.setText("");
                serialTxt.setText("");
                versionTxt.setText("");
                numMotorsTxt.setText("");
                numInTxt.setText("");
                currVelTxt.setText("");
                maxVelTxt.setText("");
                accelTxt.setText("");

                jLabel10.setVisible(false);
                currentTxt.setText("");
                currentTxt.setVisible(false);

                motorCmb.setSelectedIndex(0);
                motorCmb.removeAllItems();
                motorCmb.setEnabled(false);

                int i;
                for(i = 0; i < 4; i++)
                {
                    inputArray[i].setVisible(false);
                }
                
                maxVelScrl.setEnabled(false);
                accelScrl.setEnabled(false);
            }
        }
    }//GEN-LAST:event_accelScrlStateChanged

    /**
     * When the form is being close, make sure to stop all the motors,
     * unhook the event listeners, and close the Phidget.
     **/
    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        try
        {
            //unhook the event listeners
            mc.removeMotorVelocityChangeListener(velocity_listener);
            mc.removeInputChangeListener(input_listener);
            mc.removeCurrentChangeListener(current_listener);
            mc.removeErrorListener(error_listener);
            mc.removeDetachListener(detach_listener);
            mc.removeAttachListener(attach_listener);
            
            //stop the motors
            for(int i =0; i < mc.getMotorCount(); i++)
            {
                mc.setVelocity(i, 0);
            }
            
            //close the motor control phidget
            mc.close();
            
            mc = null;
            
            dispose();
            System.exit(0);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }//GEN-LAST:event_formWindowClosed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new MotorControl().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSlider accelScrl;
    private javax.swing.JTextField accelTxt;
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JTextField currVelTxt;
    private javax.swing.JTextField currentTxt;
    private javax.swing.JCheckBox in0Chk;
    private javax.swing.JCheckBox in1Chk;
    private javax.swing.JCheckBox in2Chk;
    private javax.swing.JCheckBox in3Chk;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSlider maxVelScrl;
    private javax.swing.JTextField maxVelTxt;
    private javax.swing.JComboBox motorCmb;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField numInTxt;
    private javax.swing.JTextField numMotorsTxt;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
    
}
